/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'modules/navigation/PanelNavigationItemView', 'modules/navigation/NavItems', 'modules/app-about/AboutPopupView', 'modules/navigation/ExitNavigationPopupView', 'hbs!modules/navigation/panelNavigation' ],
    function (Portal, Backbone, Marionette, $, jqm, PanelNavigationItemView, NavItems, AboutPopupView, ExitNavigationPopupView, template) {
    return Backbone.Marionette.CompositeView.extend({
        template : template,
        itemView: PanelNavigationItemView,
        itemViewContainer: "#portal-nav-toplist",
        // "scrollable" only on toplist,
        initialize : function (options) {
            _.bindAll(this);
            this.isPortal = Portal.uber === undefined ? true : Portal.uber;

            this.exitPopup = new ExitNavigationPopupView();
            this.aboutPopup = new AboutPopupView();
        },
        onRender : function () {
            this.$el.trigger('create');
            this.setHeightStyle();
        },
        onShow : function () {
            this.$el.trigger('create');
            Portal.vent.on('closePanel', function (page) {
                Portal.panelRegion.$el.panel('close');
            });

            Portal.vent.on('openPanel', function (page) {
                Portal.panelRegion.$el.panel('open');
            });

            Portal.vent.trigger('openPanel');
        },
        onAfterItemAdded: function (itemView) {
            var $itemViewContainer = $(this.itemViewContainer),
                itemViewContainerClasses = $itemViewContainer.attr('class');
            if (itemViewContainerClasses && itemViewContainerClasses.indexOf('ui-listview') >= 0) {
                $itemViewContainer.listview('refresh');
            } else {
                $itemViewContainer.listview();
            }
        },
        ui: {
            "topList": "#user-nav-toplist",
            "bottomList": "#user-nav-bottomlist"
        },
        events : {
            "tap li": "closePanel",
            "tap #portal-exit-btn": "exit",
            "tap #portal-about-btn": "about",
            "keydown li": function(e) { if (e.which === 13 /* Enter */) this.closePanel(); },
            "keydown #portal-exit-btn": function(e) { if (e.which === 13 /* Enter */) this.exit( e ); },
            "keydown #portal-about-btn": function(e) { if (e.which === 13 /* Enter */) this.about( e ); }
        },
        closePanel: function (e) {
            Portal.vent.trigger('closePanel');
        },
        modelEvents: {
            "change" : "userChanged"
        },
        onClose: function() {
            var exitPopupEl = '#' + this.exitPopup.id;
            var aboutPopupEl = '#' + this.aboutPopup.id;
            $(window).off('resize.nav');

            $(exitPopupEl).popup('destroy');
            $(exitPopupEl).remove();
            $(aboutPopupEl).popup('destroy');
            $(aboutPopupEl).remove();
        },
        userChanged: function (e) {
            this.render();
        },
        setHeightStyle: function() {
            var self = this,
                $itemViewContainer = $(this.el).find(this.itemViewContainer);
            
            this.$el.attr('style', this.calculateHeight());
            $itemViewContainer.attr('style', this.calculateTopListHeight());

            $(window).on('resize.nav', function () {
                self.$el.attr('style', self.calculateHeight());
                $itemViewContainer.attr('style', self.calculateTopListHeight());
            });
        },
        calculateHeight: function() {
            var self = this,
                footerHeight = $(Portal.infobarFooterRegion.el).outerHeight() - 4,
                populatedZones =
                $(Portal.infobarRegion.el).outerHeight() +
                footerHeight - 4;
                // +4 from position top/bottom of fixed headers and footers

            return ('height:' + ($(window).innerHeight() - populatedZones) + 'px; margin-bottom: ' + footerHeight + 'px;');
        },
        calculateTopListHeight: function() {
            var self = this,
                populatedZones =
                $(Portal.infobarRegion.el).outerHeight() +
                $(Portal.infobarFooterRegion.el).outerHeight() - 6 +
                44 + 15; // number of elements in bottom list and its padding-top
                // - 6 from position top/bottom of fixed headers and footers

            return ('height:' + ($(window).innerHeight() - populatedZones) + 'px;');
        },
        about: function(e) {
            if(e) e.preventDefault();
            Portal.commands.execute("open-portal-about");
        },
        exit: function(e) {
            if(e) e.preventDefault();
            Portal.commands.execute("open-portal-exit");
        }
    });
});